const bcrypt = require("bcrypt");
const User = require("./../../models/admin/AdminUser");
const { generateToken } = require('../../helper/jwtHelper');

//create admin user
const createUser = async (req, res) => {
    const { username, password, name } = req.body;

    try {
        const user = await User.findOne({where: {username}});
        if(user){
            console.log('User already found with email:',username );
            return res.status(401).json({ message: "User already found with this email" });
        }

        const saltRounds = 10;
        const hashedPassword = await bcrypt.hash(password, saltRounds);

        const newUser = await User.create({
            name,
            username,
            password: hashedPassword,
            role: "admin"
        });

        return res.status(201).json({
            message: "User created successfully",
            user: {
                user_id: newUser.user_id,
                username: newUser.username,
            },
        });
    } catch (error) {
        console.error("Error creating user:", error);
        return res.status(500).json({ message: "Internal server error" });
    }
};

const loginUser = async (req, res) => {
    const { username, password } = req.body;

    try {
        const user = await User.findOne({where: {username}});

        if(!user){
            if (!user) {
                console.log('User not found with email:',username );
                return res.status(401).json({ message: "No user found" });
            }
        }

        const isPasswordValid = await bcrypt.compare(password, user.password);

        if (isPasswordValid) {
            const token = generateToken(user.id, user.username);
            console.log('User authenticated!');
            return res.status(201).json({
                message: "User login successfully",
                user: {
                    user_id: user.user_id,
                    username: user.username,
                    name: user.name,
                    token
                },
            });
          } else {
            console.log('Invalid password');
            return res.status(201).json({
                error:true,
                message: "Invalid password",
                password: user.password,
                passwordtwo: password
            });
          }

        
    } catch (error) {
        console.error("Error creating user:", error);
        return res.status(500).json({ message: "Internal server error" });
    }
};

const dashboard = async (req,res) => {
    return res.status(201).json({message:"welcome to caterers bazar"});
}
module.exports = {
    createUser,
    loginUser,
    dashboard
}