const jwt = require('jsonwebtoken');
require('dotenv').config(); // Load environment variables

// Function to generate a JWT token
const generateToken = (userId, email) => {
  const payload = {
    userId,
    email,
  };

  const options = {
    expiresIn: '2h', // Set token expiration (e.g., 1 hour)
  };

  return jwt.sign(payload, process.env.JWT_SECRET_KEY, options);
};

// Function to verify a JWT token
const verifyToken = (token) => {
  try {
    return jwt.verify(token, process.env.JWT_SECRET_KEY);
  } catch (err) {
    return null; // If token is invalid or expired, return null
  }
};

module.exports = { generateToken, verifyToken };