const { verifyToken } = require('../../../helper/jwtHelper'); // Import the JWT helper

const authenticate = (req, res, next) => {
  // Get token from Authorization header
  const token = req.header('Authorization')?.replace('Bearer ', '');

  // If no token is provided
  if (!token) {
    return res.status(401).json({ message: 'Access denied. No token provided.' });
  }

  // Verify the token
  const decoded = verifyToken(token);

  // If token is invalid or expired
  if (!decoded) {
    return res.status(401).json({ message: 'Invalid or expired token' });
  }

  // Attach decoded user info to the request object
  req.user = decoded;

  // Proceed to the next middleware or route handler
  next();
};

module.exports = authenticate;