const { DataTypes } = require('sequelize');
const sequelize = require('../../config/database'); // Update with your database connection file path
const Category = require('./../category/Category'); // Import the Category model

const EavAttribute = sequelize.define('EavAttribute', {
  eav_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    autoIncrement: true,
    primaryKey: true
  },
  eav_label: {
    type: DataTypes.STRING,
    allowNull: false
  },
  category_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: Category,
      key: 'category_id'
    },
    index: true
  },
  position: {
    type: DataTypes.INTEGER,
    allowNull: true
  },
  eav_code: {
    type: DataTypes.STRING,
    allowNull: false,
    index: true
  },
  created_at: {
    type: DataTypes.DATE,
    defaultValue: DataTypes.NOW
  },
  updated_at: {
    type: DataTypes.DATE,
    defaultValue: DataTypes.NOW
  }
}, {
  timestamps: false,
  tableName: 'eav_attribute'
});

module.exports = EavAttribute;