const { DataTypes } = require("sequelize");
const sequelize = require("../../config/database"); // Update with your database connection file path
const Vendor = require("./Vendor"); // Import the Vendor model

const VendorDetails = sequelize.define(
  "VendorDetails",
  {
    vendor_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Vendor,
        key: "id",
      },
      index: true,
    },
    contact_person: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    stress_address_1: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    stress_address_2: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    state: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    country: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    pin_code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    additional_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vendor_description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    vendor_latitude: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    vendor_longitude: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    company_logo: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    company_gst: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    timestamps: false,
    tableName: "vendor_details",
  }
);
const VendorMedia = sequelize.define(
  "VendorMedia",
  {
    vendor_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Vendor,
        key: "id",
      },
      index: true,
    },
    media_url: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    media_type: {
      type: DataTypes.STRING,
      allowNull: false,
    },
  },
  {
    timestamps: false,
    tableName: "vendor_media",
  }
);

const VendorSocialLink = sequelize.define(
  "VendorSocialLink",
  {
    vendor_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Vendor,
        key: "id",
      },
      index: true,
    },
    vendor_facebook_link: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vendor_instagram_link: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vendor_x_link: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vendor_pintrest_link: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vendor_linkedin_link: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    timestamps: false,
    tableName: "vendor_sociallink",
  }
);

const VendorReview = sequelize.define(
  "VendorReview",
  {
    vendor_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Vendor,
        key: "id",
      },
      index: true,
    },
    rating: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    reviewer_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    reviewer_email: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    reviewer_mobile: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    reviewer_message: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    quality_rating: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: false,
    },
  },
  {
    timestamps: false,
    tableName: "vendor_review",
  }
);

module.exports = { VendorDetails, VendorMedia, VendorSocialLink, VendorReview };
