const express = require("express");
const path = require('path');
const bodyParser = require('body-parser');
const cors = require('cors');  // Import the cors package
const sequelize = require("./config/database");
const adminRoutes = require("./routes/admin/adminUser")
const app = express();
const PORT = process.env.PORT || 5002;

const corsOptions = {
  origin: ['http://localhost:5002', 'http://anotherdomain.com'], // Allow only these origins
  methods: ['GET', 'POST', 'PUT', 'DELETE'], // Allow only these methods
  allowedHeaders: ['Content-Type', 'Authorization'], // Allow these headers
};
// Middleware
app.use(cors(corsOptions));
app.use(bodyParser.json()); // To parse JSON request bodies

app.use('/V1/api/catereradmin',adminRoutes);

app.use(express.static(path.join(__dirname, 'frontend/build')));
app.get("*", (req, res) => {
  res.sendFile(path.join(__dirname, 'frontend/build', 'index.html'));
});

sequelize
  .authenticate()
  .then(() => {
    app.listen(PORT, () => {
      console.log(`Example app listening on port ${PORT}!`);
    });
  })
  .catch((err) => {
    console.error("Unable to connect:", err);
  });
